(eval-when (:compile-toplevel :load-toplevel)
  (asdf:operate 'asdf:load-op 'xlunit)
  (use-package :xlunit))

(defclass <bio-agents-tests> (test-case)
  ((sequence1-id  :accessor seq1-id :initform "P49643")
   (sequence1-seq :accessor seq1-seq)
   (top-blast-results :accessor top-blast-results)
   (clustal-result :accessor clustalw-result)))

(defmethod set-up ((tcase <bio-agents-tests>))
  (setf (seq1-seq tcase) (invoke-agent-service 'nig 'protein-lookup (seq1-id tcase)))
  (setf (top-blast-results tcase) (invoke-agent-service 'nig 'blast (seq1-seq tcase))))

;;  (setf (top-blast-results tcase) (invoke-agent-service 'nig 'blast (seq1-seq tcase)))
;;  )
  
  
(def-test-method test-protein-lookup ((tcase <bio-agents-tests>) :run nil)
  (assert-equal (seq1-seq tcase)
		'(">P49643|DNA primase large subunit (EC 2.7.7.-) (DNA primase 58 kDa subunit)"
 "MEFSGRKWRKLRLAGDQRNASYPHCLQFYLQPPSENISLIEFENLAIDRVKLLKSVENLGVSYVKGTEQYQSKLESELRKLKFSYRENLEDEYEPRRRDHISHFILRLAYCQSEELRRWFIQQEMDLLRFRFSILPKDKIQDFLKDSQLQFEAISDEEKTLREQEIVASSPSLSGLKLGFESIYKIPFADALDLFRGRKVYLEDGFAYVPLKDIVAIILNEFRAKLSKALALTARSLPAVQSDERLQPLLNHLSHSYTGQDYSTQGNVGKISLDQIDLLSTKSFPPCMRQLHKALRENHHLRHGGRMQYGLFLKGIGLTLEQALQFWKQEFIKGKMDPDKFDKGYSYNIRHSFGKEGKRTDYTPFSCLKIILSNPPSQGDYHGCPFRHSDPELLKQKLQSYKISPGGISQILDLVKGTHYQVACQKYFEMIHNVDDCGFSLNHPNQFFCESQRILNGGKDIKKEPIQPETPQPKPSVQKTKDASSALASLNSSLEMDMEGLEDYFSEDS")))

(def-test-method test-blast ((tcase <bio-agents-tests>) :run nil)
  (format t "~W~%" (top-blast-results tcase)))
(defun the-script (arg)
  (let ((lookup-service1 '(a lookup (nig)))
	(blast-service 'nig-blast)
	(lookup-service2 'nig-lookup))
    (let* ((seq (protein-lookup lookup-service1 arg))
	   (blast-result (do-blast blast-service (second seq)))
	   (top-matches (cdr (take 3 (nig-blast-extract-result blast-result))))
	   (top-matches-seq (mapcar #'(lambda (x)
					(do-sequence-lookup lookup-service2 x))
				    top-matches)))
      (cons seq top-matches-seq))))
;;   (clustalw (do-clustal 'nig-clustalw (cons seq top-matches-seq))))
;;      clustalw))
