(in-package :lcc-tests)

(def-suite sundry-suite :description "The sundry suite.")

(in-suite sundry-suite)

(test list-operations-test
  "Test list twiddling functions."
  (is (equal '() (lcc::unique '())))
  (is (equal '(1) (lcc::unique '(1))))
  (is (equal '(foo) (lcc::unique '(foo))))
  (is (equal '(1 2 3) (lcc::unique '(1 2 3))))
  (is (equal '(1 2 3) (lcc::unique '(1 2 3 1 2 3))))
  (is (equal '(1 2 3 4) (lcc::unique '(1 2 3 1 2 3 4))))
  (dotimes (i 5)
    (is (equal '() (lcc::jumble '())))
    (is (equal '(1) (lcc::jumble '(1)))))
  (let ((test '(1 2 3 4 5)))
    (dotimes (i 5)
      (let ((jumbled (lcc::jumble test)))
	(is (= (length test) (length jumbled)))
	(is (every (lambda (x) (and (member x test))) jumbled))
	(is (every (lambda (x) (and (member x jumbled))) test))))))


