(in-package :lcc-tests)

(def-suite incidence-calculus-suite
    :description "")

(in-suite incidence-calculus-suite)

(defun populate-database (db)
  (dolist (day '(1 2 3 4 5 6 7))
    (ic:tell db t day))
  (dolist (day '(1 3 5 7))
    (ic:tell db 'windy day))
  (dolist (day '(2 4 6))
    (ic:tell db 'calm day))
  (dolist (day '(1 2 3 4))
    (ic:tell db 'rainy day)))

(test incidence
  (let ((db (ic:make-database)))
    (is (equal (ic:incidence db t) '()))
    (is (equal (ic:incidence db nil) '()))

    (populate-database db)

    (is (equal (ic:incidence db t) '(1 2 3 4 5 6 7)))
    (is (equal (ic:incidence db nil) '()))

    (is (equal (ic:incidence db '(:and windy calm)) '()))
    (is (equal (ic:incidence db '(:and windy rainy)) '(1 3)))
    (is (equal (ic:incidence db '(:and calm rainy)) '(2 4)))

    (is (equal (ic:incidence db '(:or calm rainy)) '(1 2 3 4 6)))
    (is (equal (ic:incidence db '(:or windy (:and calm rainy)))
	       '(1 2 3 4 5 7)))))

(test probability
  (let ((db (ic:make-database)))
    (is (equal (ic:probability db t) '(0 . 0)))
    (is (equal (ic:probability db nil) '(0 . 0)))

    (populate-database db)

    (is (equal (ic:probability db t) '(7 . 7)))
    (is (equal (ic:probability db nil) '(0 . 7)))

    (is (equal (ic:probability db '(:and windy calm)) '(0 . 7)))
    (is (equal (ic:probability db '(:and windy rainy)) '(2 . 7)))
    (is (equal (ic:probability db '(:and calm rainy)) '(2 . 7)))
    (is (equal (ic:probability db '(:cond calm rainy)) '(2 . 4)))
    (is (equal (ic:probability db '(:cond calm calm)) '(3 . 3)))
    (is (equal (ic:probability db '(:cond windy windy)) '(4 . 4)))
    (is (equal (ic:probability db '(:cond windy windy)) '(4 . 4)))
    (is (equal (ic:probability db '(:cond t windy )) '(4 . 4)))
    (is (equal (ic:probability db '(:cond nil windy )) '(0 . 4)))
    (is (equal (ic:probability db '(:cond t windy )) '(4 . 4)))
    (is (equal (ic:probability db '(:cond calm windy)) '(0 . 4)))
    (is (equal (ic:probability db '(:cond rainy (:and rainy windy)))
	       '(2 . 2)))))


