(in-package :lcc)

;; In here is stuff for accessing web services that could be shared
;; amongst LCC frameworks.  We 

(eval-when (:compile-toplevel :load-toplevel)
  (proclaim '(optimize (debug 3)))
  (asdf:operate 'asdf:load-op 'pill)
  (asdf:operate 'asdf:load-op 'webservices)
  (use-package :webservices)
  #+sbcl (use-package :sb-mop)
  #+cmu (use-package :pcl))

;; (export defconstraint)

(defun fasta-exptract-protein (fasta)
  "Return only the protein fragment from the FASTA string."
  (remove #\newline (subseq fasta (position #\newline fasta))))

;; Our AGENTs must satisfy CONSTRAINTs. These are computed using
;; SERVICEs, which operate in a context defined by each AGENT.  A
;; contraint satisfaction is attempted, like an OOP method call, by
;; calling a function with an extra first argument of the role/agent
;; being invoked.

(defvar *wsdl-services* (make-hash-table))

(defun invoke-service (name method &rest args)
  (apply #'call-web-service (gethash name *wsdl-services*) method args))

(defun define-wsdl-service (name uri &rest rest)
  (setf (gethash name *wsdl-services*)
	(apply #'make-web-service :wsdl-uri uri rest)))

(defclass <agent> ()
  ((name :accessor agent-name :initarg :name)
   (roles :accessor agent-roles :initarg :roles)
   ;; An alist of (name . function)
   (constraints :accessor agent-constraints :initarg :constraints)))

(defvar *agents* nil)

(defmacro define-agent (name roles constraints)
  (let ((constraints (mapcar #'(lambda (def)
				 (format t "~S~%" (cddr def))
				 `(list ',(first def) (function (lambda ,(second def)
					   ,@(cddr def)))))
			       constraints)))
  `(progn
     (setf (gethash ',name *agents*)
	   (make-instance '<agent> :name ',name :roles ',roles
			  :constraints ,(cons 'list constraints))))))

;; Do we want agents that will perform multiple tasks?  What are the
;; benefits and losses from doing that?

(defun invoke-agent-service (agent method &rest rest)
  (let* ((agent (gethash agent *agents*))
	 (function (second (assoc method (agent-constraints agent)))))
    (apply function rest)))

;; (defun invoke-agent-service-from-pill () "Wrapper to translate
;;   between pill and web-services agents.  XXX Need to repackage
;;   arguments."  )

;; (defun invoke-service (agent-name method-name &rest args)
;;   "Call METHOD-NAME on AGENT-NAME.  "
;;   (let* ((agent (gethash agent-name *agents*))
;; 	 (methods (agent-constraints agent))
;; 	 (method (second (assoc method-name methods))))
;;     method))
;;     (apply method args)))

(defun extract-soap-result (x)
  "Most result strings seem to be buried here in the SOAP
  response.  XXX Maybe I should fix cl-webservices ;-)"
  (third (third (third (third x)))))
  
(defclass <agent> ()
  ())

(defvar *agents* (make-hash-table))

(defun create-agent (name)
  ;; We can autogenerate class from name.
  (let ((class (intern (format nil "<~A>" (symbol-name name)))))
    (setf (get-hash name *agents*) (make-instance (find-class class)))))

(defun mapappend (func objs)
  (apply #'append (mapcar func objs)))

(defun subclasses* (class)
  (remove-duplicates (cons class (mapappend #'subclasses* 
					    (class-direct-subclasses class)))))

(defun subclasses (class)
  (rest (subclasses* class)))

(defun all-generic-functions (&optional (class (find-class 't)))
  (remove-duplicates
   (mapappend #'class-direct-generic-functions (subclasses* class))))

(defun class-direct-generic-functions (class)
  (remove-duplicates (mapcar #'method-generic-function (specializer-direct-methods class))))

(defun setup-agents ()
  (setf *agents* (make-hash-table))
  (mapc (lambda (class)
	  (setf (gethash (class-name class) *agents*) (make-instance class)))
	(subclasses (find-class '<agent>))))

(defun satisfy-constraint (agent constraint args)
  ""
  (let* ((agent-name (pill::repackage agent :bio-webservices))
	 (constraint-name (pill::repackage constraint :bio-webservices))
	 (agent (gethash agent-name *agents*)))
    (apply (symbol-function constraint) agent args)))

(defun available-agents ()
  "Returns the *names* of available agents."
  (mapcar #'class-name (subclasses (find-class '<agent>))))

(defun agent-constraints (agent)
  "Returns *names* of all constraints understood by AGENT,
  including those by inheritance."
  ;; Need to find all classes between <agent> and AGENT that we then
  ;; check...  
  (mapcar #'generic-function-name
	  (remove-if #'(lambda (f)
			 (not (eq (class-of f) (find-class '<constraint-method>))))
		     (remove-duplicates (mapappend #'class-direct-generic-functions
						   (classes-between '<agent> agent))))))


(defgeneric classes-between (a b))

(defmethod classes-between ((a symbol) (b symbol))
  (classes-between (find-class a) (find-class b)))

(defmethod classes-between ((a standard-class) (b standard-class))
  "Return classes between A and B."
  ;; XXX Assume single-inheritance in the agent hierarchy.  Assume A
  ;; is a superclass of B, or B itself.
  (if (eq a b)
      '()
      (cons b (class-direct-superclasses b))))

(defclass <constraint-method> (standard-generic-function)
  ()
;;   (:metaclass #+cmu pcl:funcallable-standard-class
;; 	      #+sbcl funcallable-standard-class))

  (:metaclass funcallable-standard-class))

(defun all-constraints ()
  (remove-if #'(lambda (f)
		 (not (eq (class-of f) (find-class '<constraint-method>))))
	     (all-generic-functions '<agent>)))

(defmacro defconstraint (name signature)
  (defconstraint-transformer name signature))

(defun defconstraint-transformer (name signature)
  `(defgeneric ,name ,signature (:generic-function-class <constraint-method>)))
