(in-package :lcc)

(defmacro define-constant (name value &optional doc)
  `(defconstant ,name (if (boundp ',name) (symbol-value ',name) ,value)
     ,@(when doc (list doc))))

(defrule loop/1
  (<- (loop ?n)
	(< ?n 1)
	!
	(fail))
  (<- (loop ?n)
      (> ?n 0))
  (<- (loop ?n)
      (is ?m (- ?n 1))
      (loop ?m)))

;; Differs from DR's simulate/3 by returning the protocol in its final
;; state.  This lets us extract the common knowledge (specifically,
;; the collaborators).
(defrule simulate/4
  (<- (simulate ?ms ?agents ?prot ?protf) 
      (sim-step ?ms ?agents ?prot ?newms ?eprot)
      ! 
      (simulate ?newms ?agents ?eprot ?protf))
  (<- (simulate ?ms ?agents ?prot ?prot) 
      (not (sim-step ?ms ?agents ?prot ? ?))
      !
      (msg simulate/4/2 "?simulation finished~%" ())))

(defrule sim-step/5
  (<- (sim-step ?ms ?agents ?prot ?newms ?eprot) 
      (and (protocol-component common-knowledge ?prot ?ck)
	   (msg sim-step/5 "?ms=~%~W~%" (?ms)))
      (member ?agent ?agents) 
      (msg sim-step/5 "~ttrying agent ~W~%" (?agent)) 
      (expansion ?agent ?ms () ?prot ?restms ?omessages ?eprot) 
      (not (= ?prot ?eprot))
      (append-messages ?omessages ?restms ?newms)))

(defrule append-messages/3
  (<- (append-messages ((m ?af (=> ?m ?at)) . ?t)  ?list ((m ?at (<= ?m ?af)) . ?r))
      (append-messages ?t ?list ?r))
  (<- (append-messages () ?list ?list)))

;;;; Debug stuff

;; These are the ones we're printing right now.
(defrule msg-predicates/1
  (<- (msg-predicates ())))

(defrule msg-currently-enabled/1
  (<- (msg-currently-enabled ?predicate)
      (msg-predicates ?ll)
      (member ?predicate ?ll)))

(defrule msg/3
  (<- (msg ?l ?s ?a)
      (msg-currently-enabled ?l)
      (format ?s ?a)
      !)
  (<- (msg ?l ?s ?a)
      !))


(defrule warning/3
  (<- (warning ?l ?s ?a)
       (format "*** ~S ***: " (?l))
       (format ?s ?a)
       !))

(defrule set-protocol-name/3
  (<- (set-protocol-name ?p ?name ?p2)
       (protocol-add common-knowledge ?p (known ? (protocol-name ?name)) ?p2)))

(defrule get-protocol-name/2
  (<- (get-protocol-name ?protocol ?name)
       (protocol-member common-knowledge ?protocol (known ? (protocol-name ?name)))))

;;; Is it fair to expect union to behave properly if we don't give it
;;; sets to begin with?  OTOH, isn't it reasonable to expect union to
;;; produce a set?  OK, OK... Union works on sets, so it shouldn't
;;; take special care with bags.

(defrule union/3
  (<- (union () ?ys ?zs)
      !
      (union ?ys () ?zs))
  (<- (union (?x . ?xs) ?ys (?x . ?zs))
      (not (member ?x ?ys))
      !
      (union ?xs ?ys ?zs))
  (<- (union (?x . ?xs) ?ys ?zs)
      !
      (union ?xs ?ys ?zs)))

(defun jumble (list)
  "Take a list LST, and return a version with randomise order."
  (let* ((len (length list))
	 (pairs (mapcar #'(lambda (x)
			    (cons (random len) x))
			list))
	 (sorted (sort pairs #'(lambda (a b)
				 (< (car a) (car b))))))
    (mapcar #'cdr sorted)))

(defun unique (list &key (test #'eql))
  "Return a list containing the elements of LIST, but without duplicate entries."
  (let ((uniques '()))
    (dolist (el list)
      (when (not (member el uniques :test test))
	(push el uniques)))
    (nreverse uniques)))

(in-package :paiprolog)

(define-pill-function jumble/2 (list jumbled cont)
  (unify! jumbled (lcc::jumble (paiprolog::deref-exp list)))
  (funcall cont))

(define-pill-function aritify/2 (?term ?predicate/arity cont)
  (let ((termagain (paiprolog::deref-exp ?term)))
    (paiprolog::unify! ?predicate/arity
		       (intern (format nil "~A/~A"
				       (symbol-name (first termagain))
				       (length (rest termagain)))
			       :paiprolog)))
  (funcall cont))


(define-pill-function error/2 (string args cont)
  (declare (cl::ignore cont))
  (format t string (mapcar #'paiprolog::deref-exp args))
  (error "prolog execution aborted due to error/2 call~%"))