;;; The protocol

(in-package :lcc)

(defmacro define-framework (name &body clauses)
  (let ((prefix-clauses (paiprolog::make-anonymous clauses)))
    `(<-- (%framework ,name (def () ,prefix-clauses ())))))

(defrule framework/2
  (<- (framework ?name (def () ?y ()))
      (%framework ?name (def ? ?x ?))
      (independent-freshen ?x ?y)))

(defrule expansion-message/2
  (<- (expansion-message ?obj ?depth)
      (lisp-deref ?val (limit-depth ?obj ?depth))))

;;; {{{ Protocol expansion
;;; {{{ Top-level/interface
(defrule expansion/7
  (<- (expansion ?agent ?ms ?os ?p ?final-ms ?final-os ?final-p)
      (expansion-step ?agent ?ms ?os ?p ?new-ms ?new-os ?new-p)
      (msg expansion/7 "1 success!  looping... ?new-p=~%~W~%" (?new-p))
      (expansion ?agent ?new-ms ?new-os ?new-p ?final-ms ?final-os ?final-p))
  (<- (expansion ?agent ?ms ?os ?p ?ms ?os ?p)
      (not (expansion-step ?agent ?ms ?os ?p ? ? ?))))

(defrule expansion-step/7
  (<- (expansion-step (a ?role ?id) ?ms ?os ?p ?new-ms ?new-os ?new-p)
      (protocol-select agent ?p (== (a ?arole ?id) ?def) ?p1)
      (expand-protocol (== (a ?arole ?id) ?def) ?role ?id ?ms ?os ?p1 ?new-a ?new-ms ?new-os ?p2)
      (protocol-add agent ?p2 ?new-a ?new-p))
  (<- (expansion-step (a ?role ?id) ?ms ?os ?p ?new-ms ?new-os ?new-p)
      (not (protocol-select agent ?p (== (a ? ?id) ?) ?))
      (protocol-member framework ?p ?clause)
      (= ?clause (== (a ?role ?id) ?def))
      (expand-protocol (== (a ?role ?id) ?def) ?role ?id ?ms ?os ?p ?new-a ?new-ms ?new-os ?p2)
      (protocol-add agent ?p2 ?new-a ?new-p))
  (<- (expansion-step (a ?role ?id) ?ms0 ?os0 ?p0 ?ms1 ?os1 ?p1)
      (not (protocol-select agent ?p0 (== (a ? ?id) ?) ?))
      (not (protocol-member framework ?p0 ?clause))
      (add-role-definition ?role ?p ?p2)
      (expansion-step (a ?role ?id) ?ms0 ?os0 ?pp2 ?ms1 ?os1 ?p1)))

;;; }}}
;;; {{{ Rewrite rules

;;; Terminology: (= ?agent (a ?role ?id))
(defrule expand-protocol/10
  (<- (expand-protocol (== ?agent ?def) ? ?id ?ms ?os ?p (== ?agent ?e) ?mf ?of ?pf)
      (expansion-message (== ?agent ?def) 3)
      (nonvar ?def)
      (expand-protocol ?def ?agent ?id ?ms ?os ?p ?e ?mf ?of ?pf))
  (<- (expand-protocol (or ?a ?) ?agent ?id ?ms ?os ?p ?e ?mf ?of ?pf)
      (expand-protocol ?a ?agent ?id ?ms ?os ?p ?e ?mf ?of ?pf))
  (<- (expand-protocol (or ? ?b) ?agent ?id ?ms ?os ?p ?e ?mf ?of ?pf)
      (expand-protocol ?b ?agent ?id ?ms ?os ?p ?e ?mf ?of ?pf))
  (<- (expand-protocol (then ?a ?b) ?agent ?id ?ms ?os ?p (then ?ea ?b) ?mf ?of ?pf)
      (expand-protocol ?a ?agent ?id ?ms ?os ?p ?ea ?mf ?of ?pf))
  (<- (expand-protocol (then ?a ?b) ?agent ?id ?ms ?os ?p (then ?a ?eb) ?mf ?of ?pf)
      (closed ?a)
      (expand-protocol ?b ?agent ?id ?ms ?os ?p ?eb ?mf ?of ?pf))
  (<- (expand-protocol (<-- ?c (<= ?m ?a)) ?agent ?id ?ms ?os ?p (c (<= ?m ?a)) ?mf ?os ?pf)
      (message-select (m ?agent (<= ?m ?a)) ?ms ?mf)
      (satisfy ?id ?p ?c ?pf))
  (<- (expand-protocol (<= ?m ?a) ?agent ? ?ms ?os ?p (c (<= ?m ?a)) ?mf ?os ?p)
      (message-select (m ?agent (<= ?m ?a)) ?ms ?mf))
  (<- (expand-protocol (<-- (=> ?m ?a) ?c) ?agent ?id ?ms ?os ?p (c (=> ?m ?a)) ?ms ((m ?agent (=> ?m ?a)) . ?os) ?ph)
      (satisfy ?id ?p ?c ?pf)
      (send-message-hook ?a ?pf ?ph))
  (<- (expand-protocol (=> ?m ?a) ?agent ? ?ms ?os ?p (c (=> ?m ?a)) ?ms ((m ?agent (=> ?m ?a)) . ?os) ?pnew)
      (send-message-hook ?a ?p ?pnew))
  (<- (expand-protocol (<-- ?agent ?c) ? ?id ?ms ?os ?p (== ?agent ?def) ?ms ?os ?pf)
      (= ?agent (a ? ?))
      (satisfy ?id ?p ?c ?pf)
      (protocol-member framework ?p (== ?agent ?def)))
  (<- (expand-protocol ?agent ? ? ?ms ?os ?p (== ?agent ?def) ?ms ?os ?p)
      (= ?agent (a ? ?))
      (protocol-member framework ?p (== ?agent ?def)))
  (<- (expand-protocol (<-- null ?c) ? ?id ?ms ?os ?p (c null) ?ms ?os ?pf)
      (satisfy ?id ?p ?c ?pf))
  (<- (expand-protocol null ? ? ?ms ?os ?p (c null) ?ms ?os ?p))
  ;; Let's see if we can do this...
  (<- (expand-protocol ?borked-expression ?agent ?id ?agent ?ms ?os ?p ? ? ?)
      (error "This expression is borked.  ~W~%" (?borked-expression)) 
      (fail)))

;;; }}}
;;; {{{ Rewrite auxilliary

;; 

;; Called when sending a message.
(defrule send-message-hook/3
  (<- (send-message-hook ?a ?pf ?ph)
      (ensure-collaborator ?a ?pf ?pg)
      (msg send-message-hook/3 "?pg=~S~%" (?pg))
      (ensure-role-definition ?a ?pg ?ph)))

;;; Must succeed if it can, but should print a warning message if
;;; there is a message for an agent id which does not match with the
;;; role.
(defrule message-select/3
  (<- (message-select (m (a ?role ?id) (<= ?m ?sender)) ?messages-in ?messages-in*)
      (select (m (a ?role* ?id) (<= ?m ?sender)) ?messages-in ?messages-in*)
      (message-check ?id ?role ?role* ?m ?sender)))

(defrule message-check/5
  (<- (message-check ?id ?role ?role* ?m ?sender)
      (not (= ?role ?role*))
      (format "warning: agent ~S ignoring message ~S with inappropriate role ~S~%" (?id ?m ?role*))
      (fail))
  (<- (message-check ?id ?role ?role* ?m ?sender)
      (= ?role ?role*)))

(defrule closed/1
  (<- (closed (c ?)))
  (<- (closed (or ?a ?))
      (closed ?a))
  (<- (closed (or ? ?b))
      (closed ?b))
  (<- (closed (then ?a ?b))
      (closed ?a)
      (closed ?b))
  (<- (closed (== ? ?def))
      (closed ?def)))

(defrule satisfy/4
  (<- (satisfy ?id ?p ?exp ?pf)
      (msg satisfy/4 "attempting to satisfy ~W~%" (?exp))
      (satisfied ?id ?p ?exp ?pf)
      (msg satisfy/4 "succeeding in satisfying ~W~%?pf=~%~W~%" (?exp ?pf))))

(defrule satisfied/4
  (<- (satisfied ?id ?p (and ?a ?b) ?pf)
      !
      (satisfy ?id  ?p ?a ?pn)
      (satisfy ?id  ?pn ?b ?pf))
  (<- (satisfied ?id ?p (record-matchmaking-outcome! ?outcome) ?p)
      !
      (record-matchmaking-outcome ?p ?outcome))
  (<- (satisfied ?id ?p ?x ?pf)
      (meta-pred ?id ?x ?p ?pf ?call)
      !
      (msg satisfied/4 "metapred ~W~%" (?x))
      (call ?call)
      (msg satisfied/4 "real-call: calling ~W~%" (?x))
      (msg satisfied/4 "metapred satisfied ?call=~%~W~%?pf=~%~W~%" (?call ?pf))
      (= ?p ?pf))			;XXX OOOHHH!  This is nasty.)
  (<- (satisfied ?id ?p ?x ?p)
      (not (meta-pred ?id ?x ?p ? ?))
      (real-call? ?x)
      (msg satisfied/4 "real-call: calling ~W~%" (?x))
      (call ?x))
  (<- (satisfied ?id ?p ?x ?p)
      (protocol-member common-knowledge ?p (known ?id ?x))
      (msg satisfied/4 "satisfied 4 ~W~%" ((known ?id ?x))))
  (<- (satisfied ?id ?p ?x ?pf)
      (protocol-member common-knowledge ?p (known ?id (<-- ?x ?c)))
      (msg satisfied/4 "satisfied 5~%" ())
      (satisfy ?id ?p ?c ?pf)))

(defrule real-call?/1
  (<- (real-call? ?pred)
      (predicate-property ?pred ?prop)
      (member ?prop (built-in user))))
;; (<- (call-direct ?x)
;;     (predicate-property ?x built-in) ;
;;     (predicate-property ?x interpreted) ;
;;     (predicate-property ?x (imported-from ?)))

(defrule meta-pred/5
  (<- (meta-pred ?id (not ?x) ?p ?p (not (satisfy ?id ?p ?x ?))))
  (<- (meta-pred ?id (retract ?x) ?p ?pf (protocol-remove common-knowledge ?p (known ?id ?x) ?pf)))
  (<- (meta-pred ?id (assert ?x) ?p ?pf (protocol-add common-knowledge ?p (known ?id ?x) ?pf)))
  (<- (meta-pred ?id (setof ?x ?y ?z) ?p ?pf ?g)
      (= ?g (setof ?x (satisfy ?id ?p ?y ?pf) ?z))))

;;; }}}
;;; }}}
;;; {{{ Protocol accessors.

(defrule protocol-component/3
  (<- (protocol-component agent (def ?clauses ? ?) ?clauses))
  (<- (protocol-component framework (def ? ?clauses ?) ?clauses))
  (<- (protocol-component common-knowledge (def ? ? ?clauses) ?clauses)))

(defrule protocol-member/3
  (<- (protocol-member agent (def ?clauses ? ?) ?clause)
      (member ?clause ?clauses))
  (<- (protocol-member framework (def ? ?clauses ?) ?clause-copy)
      (member ?clause ?clauses)
      (copy-term ?clause ?clause-copy))
  (<- (protocol-member common-knowledge (def ? ? ?clauses) ?clause-copy)
      (member ?clause ?clauses)
      (copy-term ?clause ?clause-copy)))

(defrule protocol-select/4
  (<- (protocol-select agent (def ?clauses ?a ?b) ?clause (def ?r ?a ?b))
      (select ?clause ?clauses ?r))
  (<- (protocol-select framework  (def ?a ?clauses ?b) ?clause-copy (def ?a ?r ?b))
      (select ?clause ?clauses ?r)
      (copy-term ?clause ?clause-copy))
  (<- (protocol-select common-knowledge (def ?a ?b ?clauses)
		       ?clause-copy (def ?a ?b ?r))
      (select ?clause ?clauses ?r)
      (copy-term ?clause ?clausecopy)))

(defrule protocol-remove/4
  (<- (protocol-remove agent (def ?clauses ?a ?b) ?clause (def ?r ?a ?b))
      (select ?clause ?clauses ?r))
  (<- (protocol-remove framework (def ?a ?clauses ?b) ?clause (def ?a ?r ?b))
      (select ?clause ?clauses ?r))
  (<- (protocol-remove common-knowledge (def ?a ?b ?clauses) ?clause (def ?a ?b ?r))
      (select ?clause ?clauses ?r)))

(defrule protocol-add/4
  (<- (protocol-add agent (def ?clauses ?a ?b) ?x (def (?x . ?clauses) ?a ?b)))
  (<- (protocol-add framework (def ?a ?clauses ?b) ?x (def ?a (?x . ?clauses) ?b)))
  (<- (protocol-add common-knowledge (def ?a ?b ?clauses)
		    ?x (def ?a ?b (?x . ?clauses)))))

;;; }}}
