;;; This is the top level, and most of the running of simulations
;;; should happen in here.  

(in-package :lcc)

(eval-when (:compile-toplevel :load-toplevel)
  ;; This should be done via some prolog-side load operation, no?
  ;; Then, we could have a standard library search deal
  (load (merge-pathnames "prolog-library.lisp" (truename (asdf:system-definition-pathname :slowlog)))))

(defrule lcc-operators/1
  (<- (lcc-operators (== or and then <-- => <=))))

(defrule role-def/3
  (<- (role-def (def ? ?framework ?) ?role-template ?role-def)
      (member (== (a ?role-template ?) ?role-def) ?framework)))

;;; {{{ Finding entailed roles given a protocol and a role.

;;; Example: (?- (named-protocol planned-parenthood ?p)
;;;              (entailed-roles ?p (suitor ?x) ?er))

(defrule entailed-roles/3
  (<- (entailed-roles ?protocol ?role ?subroles)
      (entailed-roles ?protocol (?role) () ?subroles)))

(defrule entailed-roles/4
  ;;:mode (entailed-roles +protocol +frontier +checked -answer)
  (<- (entailed-roles ?protocol () ?checked ?checked))
  (<- (entailed-roles ?protocol (?role . ?frontier) ?checked ?answer)
      (member ?role ?checked)
      (entailed-roles ?protocol ?frontier ?checked ?answer))
  (<- (entailed-roles ?protocol (?role . ?frontier) ?checked ?answer)
      (not (member ?role ?checked))
      (immediate-subsequent-roles ?protocol ?role ?subroles)
      (union ?subroles ?frontier ?agenda)
      (entailed-roles ?protocol ?agenda (?role . ?checked) ?answer)))

(defrule immediate-subsequent-roles/3
  (<- (immediate-subsequent-roles ?protocol ?role ?roles)
      (role-def ?protocol ?role ?def)
      (%immediate-subsequent-roles ?def () ?roles)))

(defrule %immediate-subsequent-roles/3
  ;; These two are for the role itself.
  (<- (%immediate-subsequent-roles (a ?role ?) ?sofar (?role . ?sofar))
      (not (member ?role ?sofar))
      !)
  (<- (%immediate-subsequent-roles (a ?role ?) ?sofar ?sofar)
      (member ?role ?sofar)
      !)
  ;; Operators not involving role change directly, but possibly
  ;; containing clauses which do.
  (<- (%immediate-subsequent-roles ?term ?sofar ?subroles)
      (= ?term (?f ?a ?b))
      (member ?f (then or and))
      (%immediate-subsequent-roles ?a ?sofar ?midway)
      (%immediate-subsequent-roles ?b ?midway ?subroles)
      !)
  ;; Operators not involving role change directly, nor containing any
  ;; indirectly.
  (<- (%immediate-subsequent-roles ?term ?roles ?roles)
      (= ?term (?f ?a ?b))
      (member ?f (<= =>))
      !)
  ;; ifs that don't involve role change
  (<- (%immediate-subsequent-roles (<-- ?predicate (<= ? ?)) ?roles ?roles)
      (not (= ?predicate (a ? ?)))
      !)
  (<- (%immediate-subsequent-roles (<-- (=> ? ?) ?predicate) ?roles ?roles)
      (not (= ?predicate (a ? ?)))
      !)
  ;; finally!  ifs that DO involve role change
  (<- (%immediate-subsequent-roles (<-- (a ?role ?) (<= ? ?)) ?roles ?roles*)
      (adjoin ?role ?roles ?roles*)
      !)
  (<- (%immediate-subsequent-roles (<-- (=> ? ?) (a ?role ?)) ?roles ?roles*)
      (adjoin ?role ?roles ?roles*)
      !)
  ;; Every agent can fulfil the null role, so we can ignore it.
  (<- (%immediate-subsequent-roles null ?sofar ?sofar)
      !)
  (<- (%immediate-subsequent-roles ?term ? ?)
      (error "roles-subroles/3: Not handling term ~W~%" (?term))
      !))

;;; }}}
;;; {{{ Extracting contraints from a role definition

;;; Example: (?- (named-protocol planned-parenthood ?p)
;;;              (role-def ?p (suitor ?x) ?roledef)
;;;              (constraints ?roledef ?constraints))

(defrule test-constraints/1
  (<- (test-constraints ?constraints) 
      (named-protocol planned-parenthood ?p)
      (entailed-constraints ?p (suitor ?x) ?constraints)))

(defrule constraints/2
  (<- (constraints ?roledef ?constraints)
      (constraints ?roledef () ?macroconstraints)
      (decompose-constraints ?macroconstraints ?constraints)))

(defrule decompose-constraints/2
  (<- (decompose-constraints () ())
      !)
  (<- (decompose-constraints ((not ?x) . ?xs) ?constraints)
      !
      (decompose-constraints (?x . ?xs) ?constraints))
  (<- (decompose-constraints ((and ?x ?y) . ?rest) ?constraints)
      !
      (decompose-constraints (?x ?y . ?rest) ?constraints))
  (<- (decompose-constraints ((or ?x ?y) . ?rest) ?constraints)
      !
      (decompose-constraints (?x ?y . ?rest) ?constraints))
  (<- (decompose-constraints (?c . ?rest) ?constraints)
      !
      (decompose-constraints ?rest ?rest+)
      (aritify ?c ?c1)
      (adjoin ?c1 ?rest+ ?constraints)))

(defrule constraints/3
  (<- (constraints (<-- ?constraint (<= ? ?)) ?constraints ?constraints+)
      !
      (if (not (= ?contstraint (a ? ?)))
	  (adjoin ?constraint ?constraints ?constraints+)
	  (= ?constraints ?constraints+)))
  (<- (constraints (<-- (=> ? ?) ?constraint) ?constraints ?constraints+)
      !
      (if (not (= ?constraint (a ? ?)))
	  (adjoin ?constraint ?constraints ?constraints+)
	  (= ?constraints ?constraints+)))
  (<- (constraints (a ? ?) ?constraints ?constraints)
      !)
  (<- (constraints ?term ?constraints ?constraints+)
      (= ?term (?f ?a ?b))
      (member ?f (then or and))
      !
      (constraints ?a ?constraints ?midway)
      (constraints ?b ?midway ?constraints+))
  ;; Operators not involving role change directly, nor containing any
  ;; indirectly.
  (<- (constraints ?term ?constraints ?constraints)
      (= ?term (?f ?a ?b))
      (member ?f (<= =>))
      !)
  ;; Every agent can fulfil the null role, so we can ignore it.
  (<- (constraints null ?constraints ?constraints)
      !)
  (<- (constraints ?term ? ?)
      !
      (error "roles-subroles/3: Not handling term ~W~%" (?term))))

(defrule entailed-constraints/3
  (<- (entailed-constraints (def ? ?framework ?) ?seed-role ?constraints)
      (entailed-roles (def ? ?framework ?) ?seed-role ?all-roles)
      (bagof ?constraints1
	     (and (member ?each-role ?all-roles)
		  (format "entailed-constraints: ~S~%" (?each-role))
		  (role-def (def ? ?framework ?) ?each-role ?roledef)
		  (format "entailed-constraints: ~S~%" (?roledef))
		  (constraints ?roledef ?constraints1))
	     ?constraints2)
      (format "entailed-constraints: ~S~%" (?constraints2))
      (union-list ?constraints2 ?constraints3)
      (unique ?constraints3 ?constraints)))

;;; }}}
;;; {{{ Simulation support

(defrule setup-protocol/4
  (<- (setup-protocol ?framework-name ?matchmaking-policy
		      ?collaborator-substitutions ?protocol)
      (framework ?framework-name ?fw)
      (set-protocol-name ?fw ?framework-name ?fw1)
      (set-matchmaking-policy ?fw1 ?matchmaking-policy ?fw2)
      (add-collaborators ?collaborator-substitutions ?fw2 ?protocol)))

;; Return a named protocol copy of framework ?name.
(defrule named-protocol/2
  (<- (named-protocol ?name ?protocol)
      (framework ?name ?p)
      (set-protocol-name ?p ?name ?protocol)))
;;; }}}
;;; {{{ Framework specific simulation stuff

(defrule do-simulation/2
  (<- (do-simulation bio ?protocol+)
      (bio-agents ?agents)
      (setup-protocol bio random-incremental () ?protocol)
      (simulate () ?agents ?protocol ?protocol+))
  (<- (do-simulation planned-parenthood ?protocol)
      (setup-protocol planned-parenthood random-incremental () ?p)
      (simulate ()
		((a (suitor juliette) romeo) (a beloved juliette)
		 (a (groom juliette) romeo) (a bride romeo) juliette)
		?p ?protocol)))

(defrule do-simulation/3
  (<- (do-simulation ipo ?policy ?protocol+)
      (framework-agents ipo ?agents)
      (setup-protocol ipo ?policy () ?protocol)
      (simulate () ?agents ?protocol ?protocol+))
  ;; (?- (do-simulation planned-parenthood -?protocol))
)
;;; }}}