(in-package :lcc)

(defvar *results* '())

(define-pill-function reset-results-database/0 (cont)
  (setf *results* '())
  (funcall cont))

(define-pill-function record-result/1 (?+list cont)
  (push (paiprolog::deref-exp ?+list) *results*)
  (funcall cont))

(defun print-results (&key (skip 1))
  (remove-if-not #'(lambda (line)
		     (= 0 (mod (second line) skip)))
		 (reverse *results*)))

(defun split-by-first (list)
  (labels ((accumulate-on-first (from splits acc)
	     (cond ((null from)
		    (if acc
			(cons (reverse acc) splits)
			splits))
		   ((null acc)
		    (accumulate-on-first (rest from) splits (list (first from))))
		   ((/= (first (first from)) (first (first acc)))
		    (accumulate-on-first (rest from) (cons (reverse acc) splits)
					 (list (first from))))
		   (t
		    (accumulate-on-first (rest from) splits (cons (first from)
								  acc))))))
    (reverse (accumulate-on-first list '() '()))))

(defun dump-results (&key (filename nil))
  (let ((stream (if filename
		    (open filename :direction :output :if-exists :supersede)
		    t)))
    (loop for group in (reverse (split-by-first (print-results)))
       do (loop for point in (reverse group)
	     do (format stream "~S ~S ~S~%" (first point) (second point)
			(third point)))
       (format stream "~%"))
    (if filename
	(close stream))))

;; We use the global variable `threshold' to hold a value that the
;; agents use to determine their success likelihood.  

(defrule threshold/1
  (<- (threshold ?x)
      (%get-variable threshold ?x)))

(defrule set-threshold/1
  (<- (set-threshold ?x)
      (%set-variable threshold ?x)))

(defrule epsilon->/3
  (<- (epsilon-> ?x ?y ?e)
      (is ?y* (+ ?y ?e))
      (> ?x ?y*)))

;; (?- (run-experiment ipo random-incremental 0.0 1.0 1 1))

;; XXX Use a more general, data-driven mechanism for specifying the
;; iteration and threshold parameters.  That would allow for
;; multi-dimensional simulations.
(defrule run-experiment/6
  (<- (run-experiment ?protocol-name ?policy ?lower-bound ?upper-bound ?step ?iterations-per-step)
      (reset-results-database)
      (run-experiment* ?protocol-name ?policy ?lower-bound ?upper-bound ?step ?iterations-per-step)))

(defrule run-experiment*/6
  (<- (run-experiment* ? ? ?lower-bound ?upper-bound ? ?)
      (epsilon-> ?lower-bound ?upper-bound 0.001)
      (format "run-experiment* done"())
      !)
  (<- (run-experiment* ?protocol-name ?policy ?lower-bound ?upper-bound ?step ?iterations-per-step)
      (reset-matchmaker-database)
      (set-threshold ?lower-bound)
      (msg run-experiment*/6 "?iterations-per-step=~S~%" (?iterations-per-step))
      (cycle-inner ?protocol-name ?policy ?iterations-per-step)
      (msg run-experiment*/6 "?how'd get here?~%" ())
      (is ?lower-bound* (+ ?lower-bound ?step))
      !
      (run-experiment* ?protocol-name ?policy ?lower-bound* ?upper-bound ?step ?iterations-per-step)))

;; XXX Translate this to a recursive version when we can do tail-call
;; elimination.
(defrule cycle-inner/3
  (<- (cycle-inner ?framework-name ?policy ?iterations)
      (loop ?iterations)
      (msg cycle-inner/3 "?iterations=~S~%" (?iterations))
      (framework-agents ?framework-name ?agents)
      (setup-protocol ?framework-name ?policy () ?fw)
      (simulate () ?agents ?fw ?final-dialogue-state)
      (record-results)
      (fail))
  (<- (cycle-inner ?framework-name ?policy ?iterations)
      !))

(defrule record-results/0
  (<- (record-results)
      (threshold ?t)
      (ask (outcome good) ?g)
      (eval-length ?g ?gl)
      (ask t ?a)
      (eval-length ?a ?al)
      (record-result (?t ?al ?gl))))

(defrule run-simulation/2
  (<- (run-simulation ?protocol-name ?framework-finish)
      (framework-agents ipo ?agents)
      (framework ipo ?framework-start)
      (simulate () ?agents ?framework-start ?framework-finish)))



