(defpackage phd-system
  (:use :common-lisp :asdf))

(in-package :phd-system)

(defsystem lcc
    :description "Lightweight Coordination Calculus"
    :version "0.1"
    :author "Dave Lambert <d.j.lambert@gmail.com>"
    :licence "Hmm.  Not my place to say"
    :depends-on (:slowlog :cl-gsl)
    :components
    ((:module :src :components
	      ((:file "empirical" :depends-on ("defpackage" "sundry"))
	       (:file "incidence-calculus" :depends-on ("defpackage"))
	       (:file "lcc" :depends-on ("defpackage" "protocol"))
	       (:file "math" :depends-on ("defpackage"))
	       (:file "matchmaker" :depends-on
		      ("incidence-calculus" "defpackage"))
	       (:file "defpackage")
	       (:file "protocol" :depends-on ("defpackage"))
	       (:file "sundry" :depends-on ("defpackage"))))))

(defsystem lcc-tests
  :depends-on (:lcc :fiveam)
  :components
  ((:module :tests :components
	    ((:file "defpackage")
	     (:file "incidence-calculus" :depends-on ("defpackage"))
	     (:file "sundry" :depends-on ("defpackage"))))))

(defsystem lcc-webservices
  :description "Lightweight Coordination Calculus for Web Services"
  :version "0.1"
  :author "Dave Lambert <d.j.lambert@gmail.com>"
  :licence "Hmm.  Not my place to say"
  :depends-on (:lcc :webservices)
  :components
  ((:module :src :components
	    ((:file "web-services" :depends-on ("defpackage" "protocol"))))))

(defsystem lcc-experiments
    :description "My PhD code"
    :version "0.1"
    :author "Dave Lambert <d.j.lambert@gmail.com>"
    :licence "Hmm.  Not my place to say"
    :depends-on (:gnuplot :lcc)
    :components
    ((:module :experiments  :components
	      ((:file "data")
	       (:file "generate")
	       (:file "plotting")))))

(defsystem phd
    :description "PhD Experiments"
    :version "0.1"
    :author "Dave Lambert <d.j.lambert@gmail.com>"
    :licence "Top Secret!"
    :depends-on (:lcc :lcc-experiments :lcc-tests))

