(in-package :lcc)

(define-framework astrogrid
  
  (== (a astronomer ?astronomer)
      (then (<-- (=> (search ?filename) (a black-hole-finder ?bhf))
		 (file ?filename))
	    (or
	     (then (<= success (a black-hole-finder ?bhf))
		   (then (<-- (receive-visualisation ?thing ?v)
			      (<= (visualising ?thing) (a visualiser ?v)))
			 (=> (matchmaking good) (a matchmaker matchmaker))))
	     (then (<= failed (a black-hole-finder ?bhf))
		   (=> (matchmaking bad) (a matchmaker matchmaker))))))

  (== (a black-hole-finder ?bhf)
      (then (<= (search ?filename) (a astronomer ?astronomer))
	    (then (=> (grid-ftp-get ?filename) (a astronomy-database ?ad))
		  (then (<= (grid-ftp-file ?file) (a astronomy-database ?ad))
			(or (then  (<-- (=> success (a astronomer ?astronomer))
					(black-hole-present ?file ?black-hole))
				   (=> (visualise ?black-hole ?astronomer) (a visualiser ?v)))
			    (=> failed (a astronomer ?astronomer)))))))

  (== (a astronomy-database ?ad)
      (then (<= (grid-ftp-get ?filename) (a black-hole-finder ?bhf))
	    (<-- (=> (grid-ftp-file ?file) (a black-hole-finder ?bhf))
		 (grid-ftp-send ?filename ?ad ?bhf ?file))))

  (== (a visualiser ?v)
      (then (<= (visualise ?thing ?client) (a ? ?requester))
	    (<-- (=> (visualising ?thing) (a ? ?client))
		 (serve-visualisation ?thing ?client))))

  (== (a matchmaker matchmaker)
      (<-- (record-matchmaking-outcome! ?outcome)
	   (<= (matchmaking ?outcome) (a ? ?)))))

(defrule matchmake-roles/2
  (<- (matchmake-roles astrogrid (astronomy-database black-hole-finder visualiser))))

(defrule framework-agents/2
  (<- (framework-agents astrogrid ?agents)
      (setof (a ?role ?agent) (agent-role ?agent ?role) ?service-agents)
      (append ?service-agents
	      ((a matchmaker matchmaker) (a astronomer astrid))
	      ?agents)))

(defrule agent-role/2
  (<- (agent-role ?agent ?role)
      (grid-node ?agent ?roles)
      (member ?role ?roles)))

(defrule grid-node/2
 (<- (grid-node hpcx (black-hole-finder)))
 (<- (grid-node barcelona (black-hole-finder)))
 (<- (grid-node sdsc (black-hole-finder)))
 (<- (grid-node greenwich (astronomy-database)))
 (<- (grid-node herschel (astronomy-database)))
 (<- (grid-node keck (astronomy-database)))
 (<- (grid-node visualiser (visualiser))))

;; Measured in ... oh ... Mbps.
(defrule network-bandwidth/3
  (<- (network-bandwidth barcelona greenwich 1.0))
  (<- (network-bandwidth barcelona herschel 0.8))
  (<- (network-bandwidth barcelona keck 0.5))
  (<- (network-bandwidth hpcx greenwich 8.0))
  (<- (network-bandwidth hpcx herschel 2.5))
  (<- (network-bandwidth hpcx keck 2.8))
  (<- (network-bandwidth sdsc greenwich 2.0))
  (<- (network-bandwidth sdsc herschel 5.5))
  (<- (network-bandwidth sdsc keck 6.6)))

(defrule grid-ftp-send/4
  (<- (grid-ftp-send ?filename ?src ?dst good)
      (network-bandwidth ?dst ?src ?bw) 
      (threshold ?maxfilesize)
      (random 0.0 ?maxfilesize ?t) 
      (> ?bw ?t)
      !)
  (<- (grid-ftp-send ?filename ?src ?dst bad)))


(defrule black-hole-present/2
  (<- (black-hole-present good heavy) 
      !))

(defrule serve-visualisation/2
  (<- (serve-visualisation ??thing ??client)))

(defrule receive-visualisation/2
  (<- (receive-visualisation ??thing ??server)))

(defrule file/1
  (<- (file cygnus-x1)))

(defrule agents-for-role/3
  (<- (agents-for-role astrogrid ?role ?agents)
      (setof ?agent (agent-role ?agent ?role) ?agents)))
