(in-package :lcc)

(defparameter *matchmake-joint* (lcc::split-by-first *matchmake-joint-raw*))

(defun slice-at (dataset value)
  (mapcar (lambda (line)
	    (rest line))
	  (first (remove-if (lambda (group)
			      (not (= (caar group) value)))
			    dataset))))

;;; {{{ Example

(defun draw-perf-plots ()
  (let ((xaxis `(:axis :x :range (0 . 35000) :label "Set cardinality"))
	(yaxis `(:axis :y :range (2 . 30) :label "Sets"))
	(view `(:view :rotation-x 54 :rotation-z 11 :scale 1 :scale-z 1))
	(presentation `(:presentation :pm3d t :palette "gray" :ticslevel 0)))
    (gnuplot:plot
     gnuplot:*eps-term* "union.gnuplot"
     `((:splot ,*log-union-data* :title "Union" :with "lines"))
     xaxis yaxis view presentation
     `(:axis :z :range (0 . 400) :label "Milliseconds"))
    (gnuplot:plot
     gnuplot:*eps-term* "intersection.gnuplot"
     `((:splot ,*log-intersection-data* :title "Intersection" :with "lines"))
     xaxis yaxis view presentation
     `(:axis :z :range (0 . 12) :label "Milliseconds"))))

(defun draw-cia06-plots ()
  (let ((xaxis `(:axis :x :range (0.0 . 5.0) :label "File size"))
	(yaxis `(:axis :y :range (0 . 200) :label "Invocations"))
	(zaxis `(:axis :z :range (0 . 200) :label "Successful outcomes"))
	(view `(:view :rotation-x 54 :rotation-z 11 :scale 1 :scale-z 1))
	(presentation `(:presentation :ticslevel 0)))
    (gnuplot:plot gnuplot:*eps-term* "cia06/recruit-joint-versus-random.gnuplot"
	  `((:splot ,*agent-selection-incremental* :title "Recruit-Joint"
		    :with "lines")
	    (:splot ,*agent-selection-random* :title "Random"
		    :with "lines"))
	  xaxis yaxis zaxis presentation)
    (let ((xaxis `(:axis :x :range (0 . 200) :label "Invocations") )
	  (yaxis `(:axis :y :range (0 . 200) :label "Successful outcomes")))
      (gnuplot:plot gnuplot:*eps-term* "cia06/recruit-all-three.gnuplot"
		    `((:plot ,(slice-at *matchmake-joint* 5)
			     :title "Recruit-Joint" :with "lines")
		      (:plot ,(slice-at *agent-selection-incremental* 5)
			     :title "Recruit-Incremental" :with "lines")
		      (:plot ,(slice-at *agent-selection-random* 5)
			     :title "Random" :with "lines"))
		    xaxis yaxis  presentation))
    (let ((xaxis `(:axis :x :range (0 . 200) :label "Invocations") )
	  (yaxis `(:axis :y :range (0 . 100) :label "Percentage successful")))
      (gnuplot:plot gnuplot:*eps-term* "cia06/recruit-all-three-percent.gnuplot"
		    `((:plot ,(rationize (cdr (assoc 'ic-joint *avgs*)))
			     :title "Recruit-Joint" :with "lines")
		      (:plot ,(rationize (cdr (assoc 'ic-incremental *avgs*)))
			     :title "Recruit-Incremental" :with "lines")
		      (:plot ,(rationize (cdr (assoc 'random-incremental *avgs*)))
			     :title "Random" :with "lines"))
		    xaxis yaxis  presentation))

    ;;     (let ((xaxis `(:axis :x :range (0 . 200) :label "Invocations") )
;; 	  (yaxis `(:axis :y :range (0 . 100) :label "Percentage successful")))
;;       (gnuplot:plot gnuplot:*eps-term* "cia06/recruit-all-three-percent.gnuplot"
;; 		    `((:plot ,(rationize *ic-joint-at-five*)
;; 			     :title "Recruit-Joint" :with "lines")
;; 		      (:plot ,(rationize *ic-incremental-at-five*)
;; 			     :title "Recruit-Incremental" :with "lines")
;; 		      (:plot ,(rationize *random-incremental-at-five*)
;; 			     :title "Random" :with "lines"))
;; 		    xaxis yaxis  presentation))

    
    '(let ((xaxis `(:axis :x :range (300 500) :label "Money available")))
      (gnuplot:plot gnuplot:*eps-term* "cia06/embellish-incremental.gnuplot"
		    `((:splot ,(lcc::split-by-first
				(skipper (massage-role-data
					  *role-incremental-raw*) 25))
			      :title "Embellish-Incremental" :with "lines")
		      (:splot ,(lcc::split-by-first
				(skipper (massage-role-data
					  *role-random-raw*) 25))
			      :title "Random" :with "lines"))
		    xaxis yaxis zaxis presentation))
    (let ((xaxis `(:axis :x :range (0 . 35000) :label "Set cardinality"))
	  (yaxis `(:axis :y :range (2 . 30) :label "Sets"))
	  (presentation `(:presentation :pm3d t :palette "gray"
					:ticslevel 0)))
      (gnuplot:plot gnuplot:*eps-term* "cia06/set-intersection.gnuplot"
		    `((:splot ,*log-intersection-data* :title "Intersection"
			      :with "lines"))
		    xaxis yaxis view presentation
		    `(:axis :z :range (0 . 12) :label "Milliseconds")))))

(defun draw-dissertation-plots ()
  (let ((xaxis `(:axis :x :range (0.0 . 5.0) :label "File size"))
	(yaxis `(:axis :y :range (0 . 200) :label "Invocations"))
	(zaxis `(:axis :z :range (0 . 200) :label "Successful outcomes"))
	(view `(:view :rotation-x 54 :rotation-z 11 :scale 1 :scale-z 1))
	(presentation `(:presentation :ticslevel 0)))
    (gnuplot:plot gnuplot:*eps-term* "plots/recruit-joint-versus-random.gnuplot"
	  `((:splot ,*agent-selection-incremental* :title "Recruit-Joint"
		    :with "lines")
	    (:splot ,*agent-selection-random* :title "Random"
		    :with "lines"))
	  xaxis yaxis zaxis presentation)
    (let ((xaxis `(:axis :x :range (0 . 200) :label "Invocations") )
	  (yaxis `(:axis :y :range (0 . 200) :label "Successful outcomes")))
      (gnuplot:plot gnuplot:*eps-term* "plots/recruit-all-three.gnuplot"
		    `((:plot ,(slice-at *matchmake-joint* 5)
			     :title "Recruit-Joint" :with "lines")
		      (:plot ,(slice-at *agent-selection-incremental* 5)
			     :title "Recruit-Incremental" :with "lines")
		      (:plot ,(slice-at *agent-selection-random* 5)
			     :title "Random" :with "lines"))
		    xaxis yaxis  presentation))
    (let ((xaxis `(:axis :x :range (0 . 200) :label "Invocations") )
	  (yaxis `(:axis :y :range (0 . 100) :label "Percentage successful")))
      (gnuplot:plot gnuplot:*eps-term* "plots/recruit-all-three-percent.gnuplot"
		    `((:plot ,(rationize *ic-joint-at-five*)
			     :title "Recruit-Joint" :with "lines")
		      (:plot ,(rationize *ic-incremental-at-five*)
			     :title "Recruit-Incremental" :with "lines")
		      (:plot ,(rationize *random-incremental-at-five*)
			     :title "Random" :with "lines"))
		    xaxis yaxis  presentation))

    
    '(let ((xaxis `(:axis :x :range (300 500) :label "Money available")))
      (gnuplot:plot gnuplot:*eps-term* "plots/embellish-incremental.gnuplot"
		    `((:splot ,(lcc::split-by-first
				(skipper (massage-role-data
					  *role-incremental-raw*) 25))
			      :title "Embellish-Incremental" :with "lines")
		      (:splot ,(lcc::split-by-first
				(skipper (massage-role-data
					  *role-random-raw*) 25))
			      :title "Random" :with "lines"))
		    xaxis yaxis zaxis presentation))
    (let ((xaxis `(:axis :x :range (0 . 35000) :label "Set cardinality"))
	  (yaxis `(:axis :y :range (2 . 30) :label "Sets"))
	  (presentation `(:presentation :pm3d t :palette "gray"
					:ticslevel 0)))
      (gnuplot:plot gnuplot:*eps-term* "plots/set-intersection.gnuplot"
		    `((:splot ,*log-intersection-data* :title "Intersection"
			      :with "lines"))
		    xaxis yaxis view presentation
		    `(:axis :z :range (0 . 12) :label "Milliseconds")))))

(defun skipper (list skip)
  (remove-if-not #'(lambda (line) (= 0 (mod (second line) skip)))
		 list))

(defun massage-role-data (results)
  (mapcar #'(lambda (result)
	      (if (= 1 (second result))
		  (list (first result) 0 0)
		  result))
	  results))

;; (defun draw-all ()
;;   (draw-perf-plots)
;;   (draw-agent-selection-plots))


;; To generate the joint matchmaking results, we use:

;; (?- (run-experiment astrogrid ic-joint 0.5 5.0 0.5 200))
;; then
;; (print-results :skip 25)

;; Then...

(defun rationize (data)
  (mapcar #'(lambda (el)
	      (destructuring-bind (discard x good) el
		(declare (ignore discard))
		(list x (* 100 (coerce (/ good x) 'float)))))
	  data))

;;; }}}

(defun gen-the-three (m n)
  (setf *the-three* '())
  (loop for scheme in '(ic-joint ic-incremental random-incremental)
     do (progn
	  (push (cons scheme '()) *the-three*)
	  (loop for j from 1 to n
	     do (progn
		  (eval `(?- (run-experiment astrogrid ,scheme 5.0 5.1 0.5 ,m)))
		  (let ((foo (assoc scheme *the-three*)))
		    (push (lcc::print-results)  (cdr foo))))))))


(defun avg (lists)
  (if (null (first lists))
      '()
      (let ((heads (mapcar #'first lists)))
	(cons (list (first (first heads))
		    (/ (reduce #'+ (mapcar #'second heads))
		       (length heads))
		    (third (first heads)))
	      (avg (mapcar #'cdr lists))))))

(defun last-step ()
  (setf *avgs* '())
  (loop for line in *the-three*
     do (push (cons (car line) (avg (cdr line))) *avgs*)))

