(in-package :lcc)

(declaim (optimize (speed 3) (safety 0) (debug 0)))

;;; {{{ Incidence calculus operations 

;; Investigation into the run-time efficiency of IC set operations...

;; Perhaps we should think about not sorting them.  But that seems
;; pretty dim.  The random number generation will make it likely that
;; duplicates will turn up.  Should that bother us?  It would make the
;; algorithm more complicated, since we'd have to look for them.

(defun make-worlds (number-sets worlds-in-each &key (universe nil))
  "List of NUMBER-SETS lists each of WORLDS-IN-EACH numbers."
  (unless universe
    (setf universe (* number-sets worlds-in-each)))
  (loop for w from 1 to number-sets
     collect (sort (loop for n from 1 to worlds-in-each
		      collect (random universe)) #'<)))

(defvar *results* '())

(defun sort-sets (sets)
  (mapcar (lambda (set)
	    (sort set #'<))
	  sets))

(defun record-result (independant-variables dependant-variable-results)
  (push (list independant-variables dependant-variable-results) *results*))

(defun test-it-all (sets< sets> sets+ size< size> size+ samplings fn)
  (setf *results* nil)
  (loop
     for size from size< to size> by size+
     do (loop for sets from sets< to sets> by sets+
     do (let ((samples '()))
	  (loop for sample from 1 to samplings
	     do (let* ((worlds (sort-sets (make-worlds sets size))))
		  (push (time-this (funcall fn worlds)) samples)))
	  (record-result (list sets size) samples)))))

(defun arithmetic-mean (numbers)
  (/ (reduce #'+ numbers) (length numbers)))

;; (test-it-all 2 30 1 0 35000 1000 1 #'ic::log-intersection)

;; (test-it-all 2 30 2 0 35000 1000 #'ic::log-intersection)
;; ;; This line gives us a very sharp peak at the top end (20 sets of 25000 each).
;; (test-it-all 2 20 2 0 25000 1000 #'ic::log-union)

;; (test-it-all 2 30 2 0 35000 1000 #'ic::log-union)

;; (defun results-space (dimensions operation)
;;   (if (null dimensions)
;;       (record (operation))))

(defun generate-gnuplot-data (results &key which)
  (let* ((x (third (first results))))
    (labels ((process-line (id sets worlds intersection-time union-time)
	       (declare (ignore id)
			(fixnum worlds x))
	       (when (not (= worlds x))
		 (format t "~%")
		 (setf x worlds))
	       (format t "~S ~S ~S~%" worlds sets (if (eq which :intersection)
						    intersection-time
						    union-time))))
      (dolist (r results)
	(apply #'process-line r)))))

(defun sort-results (results)
  (sort results #'(lambda (x y) 
		    (if (< (third x) (third y))
			t
			(if (and (= (third x) (third y))
				 (< (second x) (second y)))
			    t
			    nil)))))


(defvar *intersection* nil)
(defvar *union* nil)

(defun do-incidence-calculus-tests ()
  (progn
    (test-it-all 2 30 1 0 35000 1000 1 #'ic::log-intersection)
    (setf *intersection* *results*)
    (test-it-all 2 30 1 0 35000 1000 1 #'ic::log-union)
    (setf *union* *results*)))


;;; }}}

;;; {{{ Agent selections

;;(load "/home/djl/dev/cl-lcc/live/frameworks/astrogrid-prefix")
'(?- (run-experiment astrogrid random-incremental 0.0 7.0 0.5 200))

;;; }}}

(defmacro time-this (form)
  (let ((start (gensym))
	(result (gensym))
	(end (gensym)))
    `(progn
       (sb-ext:gc #| :full t |# )
       (let ((,start (get-internal-run-time))
	     (,result ,form)
	     (,end (get-internal-run-time)))
	 (declare (ignore ,result))
	 (- ,end ,start)))))
